<?php
require_once(__DIR__ . '/../config.php');
require_login();

$PAGE->set_url(new moodle_url('/course/wawscatalog.php'));
$PAGE->set_context(context_system::instance());
$PAGE->set_pagelayout('standard');
$PAGE->set_title("AWS Course Catalog");
$PAGE->set_heading("AWS Course Catalog");

echo $OUTPUT->header();

global $DB;

// Pagination settings
$page    = optional_param('page', 0, PARAM_INT);
$perpage = 10; // courses per page
$fieldid = 22; // 🔹 your AWS custom field ID

// Count total AWS courses
$countsql = "SELECT COUNT(1)
               FROM {customfield_data} cf
              WHERE cf.fieldid = :fieldid";
$totalcourses = $DB->count_records_sql($countsql, ['fieldid' => $fieldid]);

// Get AWS courses
$sql = "SELECT c.id, c.fullname, cf.value AS awslaunchurl
          FROM {course} c
          JOIN {customfield_data} cf ON cf.instanceid = c.id
         WHERE cf.fieldid = :fieldid
      ORDER BY c.fullname ASC";

$courses = $DB->get_records_sql($sql, ['fieldid' => $fieldid], $page * $perpage, $perpage);

// Table
$table = new html_table();
$table->head = ['Course Name', 'Launch'];

foreach ($courses as $course) {
    $launchbtn = 'No Launch Available';

    // 🔹 Try to find the FIRST visible LTI activity in the course
    $sql = "SELECT cm.id AS cmid
              FROM {course_modules} cm
              JOIN {modules} m ON m.id = cm.module
             WHERE cm.course = ?
               AND m.name = 'lti'
               AND cm.visible = 1
          ORDER BY cm.id ASC LIMIT 1";
    $lti = $DB->get_record_sql($sql, [$course->id]);

    if ($lti) {
        // Found an LTI activity → link to it
        $url = new moodle_url('/mod/lti/view.php', ['id' => $lti->cmid]);
        $launchbtn = html_writer::link($url, 'Launch', [
            'class' => 'btn btn-primary',
           // 'target' => '_blank' // change/remove if you want same tab
        ]);
    } elseif (!empty($course->awslaunchurl)) {
        // Fallback: use custom field launch URL if no LTI exists
        $launchbtn = html_writer::link($course->awslaunchurl, 'Launch', [
            'class' => 'btn btn-secondary',
           // 'target' => '_blank'
        ]);
    }

    $table->data[] = [
        format_string($course->fullname),
        $launchbtn
    ];
}

echo html_writer::table($table);

// Pagination
$baseurl = new moodle_url('/course/wawscatalog.php');
echo $OUTPUT->paging_bar($totalcourses, $page, $perpage, $baseurl);

echo $OUTPUT->footer();
