<?php
require_once(__DIR__ . '/../../config.php');
require_login();

global $DB, $OUTPUT, $PAGE;

// Get manager ID from URL
$userid = optional_param('id', 0, PARAM_INT);

// Page setup
$context = context_system::instance();
$PAGE->set_context($context);
$PAGE->set_url(new moodle_url('/local/custompage/viewmanager.php', ['id' => $userid]));
$PAGE->set_title('Companies');
$PAGE->set_heading('Companies');
$PAGE->set_pagelayout('report');

// --- LOAD ALL CSS/JS BEFORE HEADER ---
$PAGE->requires->css('/lib/datatables/dataTables.bootstrap5.min.css');
$PAGE->requires->js('/lib/jquery/jquery.min.js');
$PAGE->requires->js('/lib/datatables/jquery.dataTables.min.js');
$PAGE->requires->js('/lib/datatables/dataTables.bootstrap5.min.js');

echo $OUTPUT->header();

// Get manager info
$manageremail = '';
$managerfullname = '';
if ($userid) {
    $manager = $DB->get_record('user', ['id' => $userid], 'email, firstname, lastname');
    if ($manager) {
        $manageremail = $manager->email;
        $managerfullname = fullname($manager);
    }
}

// Get all companies for dropdown
$allcompanies = $DB->get_records('company', null, 'com_name ASC');
?>
<style type="text/css">
    
     .company-form-container {
    width: 100%;
    max-width: 1000px; /* reduced max width for mobile */
    margin: 20px auto;
    background: #fff;
    border-radius: 10px;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
    font-family: "Segoe UI", sans-serif;
    overflow: hidden;
    padding: 10px; /* add some padding */
}
 .company-form-header {
        background-color: #f7f7f7;
        padding: 20px 30px;
        font-size: 22px;
        font-weight: bold;
        color: #2c3e50;
        display: flex;
        justify-content: space-between;
        align-items: center;
        border-bottom: 1px solid #ddd;
    }
</style>
<div class="company-form-container">
    <div class="company-form-header">
        <h3>Companies</h3>
        <div class="float-right">
            <a href="<?php echo new moodle_url('/course/wcompany.php'); ?>" class="btn btn-primary">
                Add Company
            </a>
        </div>
    </div>

    <div class="card-body">
    <!-- Filters -->
    <div class="m-b-3">
        <table class="generaltable flexible-wrap" style="background-color: transparent;">
            <tr>
                <td>
                    <label>Email</label><br>
                    <input type="text" id="filterEmail" class="form-control" value="<?php echo $manageremail; ?>" readonly>
                </td>
                <td>
                    <label>Company</label><br>
                    <select id="filterCompany" class="form-control">
                        <option value="">All Companies</option>
                        <?php foreach ($allcompanies as $comp): ?>
                            <option value="<?php echo $comp->com_name; ?>"><?php echo $comp->com_name; ?></option>
                        <?php endforeach; ?>
                    </select>
                </td>
                <td>
                    <label>From Date</label><br>
                    <input type="date" id="filterFrom" class="form-control">
                </td>
                <td>
                    <label>To Date</label><br>
                    <input type="date" id="filterTo" class="form-control">
                </td>
            </tr>
        </table>
    </div>
</div>


        <!-- Companies Table -->
        <table id="companiesTable" class="generaltable table table-bordered table-striped">
            <thead>
                <tr>
                    <th>Sr. No</th>
                    <th>Company</th>
                    <th>Email</th>
                    <th>Date</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
            <?php
            $i = 1;
            $companies = $DB->get_records('company', ['class_manager' => $userid], 'id DESC');

            foreach ($companies as $company) {
                $editurl = new moodle_url('/course/wcompany.php', ['id' => $company->id]);
                $deleteurl = new moodle_url('/course/wcompanylist.php', [
                    'delete' => $company->id,
                    'sesskey' => sesskey()
                ]);

                $editicon = $OUTPUT->action_icon($editurl, new pix_icon('t/edit', get_string('edit')));
                $deleteicon = $OUTPUT->action_icon(
                    $deleteurl,
                    new pix_icon('t/delete', get_string('delete')),
                    new confirm_action(get_string('deletecheck', '', $company->com_name))
                );

                echo '<tr>';
                echo '<td>' . $i++ . '</td>';
                echo '<td>' . format_string($company->com_name) . '</td>';
                echo '<td>' . format_string($manageremail) . '</td>';
                echo '<td>' . userdate(strtotime($company->created_at), get_string('strftimedate')) . '</td>';
                echo '<td>' . $editicon . ' ' . $deleteicon . '</td>';
                echo '</tr>';
            }
            ?>
            </tbody>
        </table>

    </div>
</div>

<script>
require(['jquery'], function($) {
    $(document).ready(function() {
        var table = $('#companiesTable').DataTable({
            "pageLength": 10,
            "lengthMenu": [[5,10,25,50,-1],[5,10,25,50,"All"]],
            "ordering": true,
            "responsive": true
        });

        // Filter by Company Dropdown
        $('#filterCompany').on('change', function() {
            table.column(1).search($(this).val()).draw();
        });

        // Filter by From/To Date
        $.fn.dataTable.ext.search.push(
            function(settings, data) {
                var from = $('#filterFrom').val();
                var to = $('#filterTo').val();
                var rowDate = new Date(data[3]);
                if ((from === "" || rowDate >= new Date(from)) &&
                    (to === "" || rowDate <= new Date(to))) {
                    return true;
                }
                return false;
            }
        );

        $('#filterFrom, #filterTo').on('change', function() {
            table.draw();
        });
    });
});
</script>

<?php
echo $OUTPUT->footer();
?>
