<?php
require_once('../../config.php');
require_login();
$context = context_system::instance();
require_capability('moodle/site:config', $context);
global $DB, $PAGE, $OUTPUT;

$PAGE->set_url(new moodle_url('/local/learningpath/bulk_enrol.php'));
$PAGE->set_context($context);
$PAGE->set_title('Bulk Enrolment to Learning Paths');
$PAGE->set_heading('Bulk Enrolment to Learning Paths');

echo $OUTPUT->header();

$paths = $DB->get_records_menu('learning_paths', null, '', 'id, name');
$cohorts = $DB->get_records_menu('cohort', null, '', 'id, name');
$users = $DB->get_records_sql_menu("SELECT id, CONCAT(firstname, ' ', lastname) AS name FROM {user} WHERE deleted = 0 AND suspended = 0 AND id > 2");

if ($_SERVER['REQUEST_METHOD'] === 'POST' && confirm_sesskey()) {
    $selectedpaths = optional_param_array('paths', [], PARAM_INT);
    $selectedusers = optional_param_array('users', [], PARAM_INT);
    $selectedcohorts = optional_param_array('cohorts', [], PARAM_INT);

    $total = 0;
    foreach ($selectedpaths as $pathid) {
        $pathcourses = $DB->get_records('learning_path_courses', ['pathid' => $pathid]);
        // Enrol individual users
        foreach ($selectedusers as $userid) {
            foreach ($pathcourses as $c) {
                enrol_try_internal_enrol($c->courseid, $userid, 5);
            }
            $enrol = new stdClass();
            $enrol->pathid = $pathid;
            $enrol->userid = $userid;
            $enrol->enrolldate = time();
            $DB->insert_record('learning_path_enrolments', $enrol);
            $total++;
        }
        // Enrol cohort members
        foreach ($selectedcohorts as $cohortid) {
            $members = $DB->get_records('cohort_members', ['cohortid' => $cohortid]);
            foreach ($members as $m) {
                foreach ($pathcourses as $c) {
                    enrol_try_internal_enrol($c->courseid, $m->userid, 5);
                }
                $enrol = new stdClass();
                $enrol->pathid = $pathid;
                $enrol->userid = $m->userid;
                $enrol->enrolldate = time();
                $DB->insert_record('learning_path_enrolments', $enrol);
                $total++;
            }
        }
    }

    echo html_writer::div("✅ Enrolled {$total} users successfully across selected paths.");
}

echo '<form method="post">';
echo sesskey();
echo '<h3>Select Learning Paths</h3>';
echo '<select name="paths[]" multiple size="5" style="width:400px;">';
foreach ($paths as $id => $name) {
    echo "<option value='{$id}'>{$name}</option>";
}
echo '</select><br><br>';

echo '<h3>Select Users</h3>';
echo '<select name="users[]" multiple size="10" style="width:400px;">';
foreach ($users as $id => $name) {
    echo "<option value='{$id}'>{$name}</option>";
}
echo '</select><br><br>';

echo '<h3>Select Cohorts</h3>';
echo '<select name="cohorts[]" multiple size="5" style="width:400px;">';
foreach ($cohorts as $id => $name) {
    echo "<option value='{$id}'>{$name}</option>";
}
echo '</select><br><br>';

echo '<input type="submit" value="Bulk Enrol" class="btn btn-primary">';
echo '</form>';

echo $OUTPUT->footer();
