<?php
require_once(__DIR__ . '/../config.php');
require_login();
global $DB, $OUTPUT;

echo $OUTPUT->header();
?>

<!-- ✅ Include DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">

<!-- ✅ Include jQuery and DataTables JS -->
<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<style>
.custom-user-table {
    max-width: 1200px;
    margin: 30px auto;
    background: #fff;
    padding: 25px;
    border-radius: 12px;
    box-shadow: 0 0 10px rgba(0,0,0,0.05);
    font-family: 'Segoe UI', sans-serif;
}
.custom-user-table h3 {
    margin-bottom: 25px;
    font-size: 20px;
    font-weight: bold;
}
.custom-user-table .btn-add {
    background-color: #007bff;
    color: #fff;
    border: none;
    padding: 6px 14px;
    border-radius: 6px;
    font-size: 14px;
    cursor: pointer;
}
.custom-user-table table {
    width: 100%;
    border-collapse: collapse;
    margin-bottom: 10px;
}
.custom-user-table th, .custom-user-table td {
    padding: 12px;
    text-align: left;
    border-bottom: 1px solid #eee;
    font-size: 14px;
}
.custom-user-table th {
    font-weight: 600;
    color: #333;
}
.custom-user-table .text-green {
    color: green;
    font-weight: 500;
}
.custom-user-table .ellipsis-btn {
    background: #f6f6f6;
    border: 1px solid #ccc;
    border-radius: 6px;
    padding: 4px 8px;
    font-weight: bold;
    font-size: 18px;
    cursor: pointer;
}
.company-actions {
    position: relative;
}

.company-ellipsis-btn {
    background: none;
    border: 1px solid #ccc;
    border-radius: 6px;
    font-size: 18px;
    padding: 4px 8px;
    cursor: pointer;
}

.company-dropdown-menu {
    display: none;
    position: absolute;
    right: 0;
    top: 35px;
    background-color: white;
    border: 1px solid #ddd;
    border-radius: 6px;
    box-shadow: 0 4px 8px rgba(0,0,0,0.1);
    z-index: 1000;
    min-width: 140px;
}

.company-dropdown-item {
    padding: 8px 12px;
    font-size: 14px;
    color: #333;
    text-decoration: none;
    display: flex;
    align-items: center;
    gap: 8px;
}

.company-dropdown-item:hover {
    background-color: #f5f5f5;
    color: #000;
}

.company-actions:hover .company-dropdown-menu {
    display: block;
}

</style>

<div class="custom-user-table">
    <h3>Users</h3>

    <div class="top-bar" style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 15px;">
        <!-- Search will be auto added by DataTables -->
        <button class="btn-add">+ Add Users</button>
    </div>

    <table id="userTable">
        <thead>
            <tr>
                <th>S.no</th>
                <th>Name/Email Address</th>
                <th>Role’s/User Type</th>
                <th>Created Date</th>
                <th>Last Login</th>
                <th>Status</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>1</td>
                <td>Vivek<br><small>vivekbhide@hotmail.com</small></td>
                <td>Class Manager</td>
                <td>31 May, 2025</td>
                <td>01 Aug, 2025</td>
                <td><span class="text-green">Active</span></td>
               <td class="company-actions">
    <button class="company-ellipsis-btn">⋯</button>
    <div class="company-dropdown-menu">
        <a href="#" class="company-dropdown-item"><i class="fa fa-eye"></i> Quick View</a>
        <a href="#" class="company-dropdown-item"><i class="fa fa-pencil"></i> Edit</a>
    </div>
</td>

            </tr>
            <tr>
                <td>2</td>
                <td>Karam<br><small>karam@whizlabs.com</small></td>
                <td>User</td>
                <td>24 Jul, 2023</td>
                <td>28 Jul, 2023</td>
                <td><span class="text-green">Active</span></td>
                <td class="company-actions">
    <button class="company-ellipsis-btn">⋯</button>
    <div class="company-dropdown-menu">
        <a href="#" class="company-dropdown-item"><i class="fa fa-eye"></i> Quick View</a>
        <a href="#" class="company-dropdown-item"><i class="fa fa-pencil"></i> Edit</a>
    </div>
</td>

            </tr>
        </tbody>
    </table>
</div>

<!-- ✅ Initialize DataTables -->
<script>
$(document).ready(function() {
    $('#userTable').DataTable({
        paging: true,
        searching: true,
        ordering: true,
        info: true,
        lengthChange: true,
        pageLength: 10,
        columnDefs: [
            { orderable: false, targets: -1 } // Disable sorting for the last column (Actions)
        ]
    });
});
</script>

<?php
echo $OUTPUT->footer();
?>
