<?php
defined('MOODLE_INTERNAL') || die();

class local_enrollmentmailer_v2_observer {
    public static function user_enrolled_handler(\core\event\user_enrolment_created $event) {
        global $DB, $CFG;

        require_once($CFG->dirroot.'/user/lib.php');

        // // Check if email sending is enabled in plugin settings
        // $enabled = get_config('local_enrollmentmailer_v2', 'enableenrollmentmail');
        // if (!$enabled) {
        //     debugging('Enrollment emails are disabled in plugin settings.', DEBUG_DEVELOPER);
        //     return true;
        // }

        // Get enrolment data
        $ue = $event->get_record_snapshot('user_enrolments', $event->objectid);

        // Get user
        $user = $DB->get_record('user', ['id' => $ue->userid], '*', MUST_EXIST);

        // FIX: Get course ID via enrol table
        $enrol = $DB->get_record('enrol', ['id' => $ue->enrolid], '*', MUST_EXIST);
        $course = $DB->get_record('course', ['id' => $enrol->courseid], '*', MUST_EXIST);

        // Prepare email subject and body from settings
        $subject = get_config('local_enrollmentmailer_v2', 'enrollmentmailsubject');
        $body    = get_config('local_enrollmentmailer_v2', 'enrollmentmailbody');

        // Replace placeholders
        $placeholders = [
            '[[user_name]]'      => fullname($user),
            '[[enrollments]]'    => $course->fullname,
            '[[login_url]]'      => $CFG->wwwroot,
            '[[user_email]]'     => $user->email,
            '[[user_password]]'  => '(set via reset link)'
        ];

        foreach ($placeholders as $key => $val) {
            $body    = str_replace($key, $val, $body);
            $subject = str_replace($key, $val, $subject);
        }

        $messagetext = html_to_text($body);

        // Send email
        $result = email_to_user($user, \core_user::get_support_user(), $subject, $messagetext, $body);

        if (!$result) {
            debugging("❌ Enrollment email failed to send to {$user->email}", DEBUG_DEVELOPER);
        } else {
            debugging("✅ Enrollment email sent successfully to {$user->email}", DEBUG_DEVELOPER);
        }

        return true;
    }
}
