<?php
defined('MOODLE_INTERNAL') || die();

class local_enrolnotify_observer {
    public static function user_enrolled_handler(\core\event\user_enrolled $event) {
        global $DB, $SITE;

        // Get user and course from event data.
        $user   = $DB->get_record('user', ['id' => $event->relateduserid], '*', MUST_EXIST);
        $course = $DB->get_record('course', ['id' => $event->courseid], '*', MUST_EXIST);

        if (!empty($user->email) && validate_email($user->email)) {
            $subject = "Enrolment Notification: {$course->fullname}";
            $messagehtml = "
                <p>Hello {$user->firstname},</p>
                <p>You have been enrolled in the course <b>{$course->fullname}</b>.</p>
                <p><a href='" . (new moodle_url('/course/view.php', ['id' => $course->id])) . "'>Click here to access the course</a></p>
                <p>Regards,<br>{$SITE->fullname}</p>";
            $messagetext = strip_tags($messagehtml);

            // Send the mail.
            email_to_user($user, core_user::get_support_user(), $subject, $messagetext, $messagehtml);
        }
    }
}
