<?php
defined('MOODLE_INTERNAL') || die();

class local_welcome_observer {
    public static function user_created_handler(\core\event\user_created $event) {
        global $DB, $CFG;

        require_once($CFG->dirroot.'/user/lib.php');
        require_once($CFG->dirroot.'/lib/moodlelib.php');

        $user = $DB->get_record('user', ['id' => $event->objectid]);
        if (!$user || empty($user->email)) {
            return true;
        }

        // Create a password reset record manually (since core_user::get_password_reset_token does not exist in Moodle 4.0)
        $token = random_string(32);
        $resetrecord = (object)[
            'userid' => $user->id,
            'token' => $token,
            'timerequested' => time(),
            'timererequested' => time()
        ];

        // Insert into user_password_resets
        $DB->insert_record('user_password_resets', $resetrecord);

        // Build reset URL
        $reseturl = $CFG->wwwroot . '/login/forgot_password.php?token=' . $token . '&id=' . $user->id;

        // Email subject & body
        $subject = "Welcome to Trainocate Portal";
        $messagehtml = "
        <p>Hi {$user->firstname} {$user->lastname},</p>
        <p>Welcome to Trainocate. Your account has been created successfully. Please find your credentials below:</p>
        <p><b>URL:</b> {$CFG->wwwroot}</p>
        <p><b>Username:</b> {$user->username}</p>
        <p>You can set up your account password by clicking on the link below:</p>
        <p><a href='$reseturl'>$reseturl</a></p>
        <p>Thanks,<br>Trainocate Team</p>
        ";

        // Plain-text fallback
        $messagetext = strip_tags(str_replace(["<br>", "<br/>", "<br />"], "\n", $messagehtml));

        // Send email
        email_to_user($user, core_user::get_support_user(), $subject, $messagetext, $messagehtml);

        return true;
    }
}
