# MOODLE - ACADEMI THEME

Academi is an intelligently responsive theme, free from the constraints of Moodle, making it perfect for your academy. It boasts a clean and highly modern design, ideally suited for your Moodle sites. This theme is entirely responsive, ensuring that your readers can enjoy browsing your site on mobile devices or tablets, guaranteeing a seamless experience. We have introduced a new theme design and added extra new blocks to enhance its functionality."

## Requirements: ##

This theme requires Moodle 4.0+

# Installation and Initial Setup

### Installation for Theme Academi

You can install the theme academi plugin using the Moodle plugin installer. Here are the steps to follow:

1. Download the [**Academi**](https://moodle.org/plugins/theme_academi) plugin from the Moodle plugins repository.
2. Copy folder 'academi' and put into theme folder of your moodle system
3. Next log in to your Moodle site as an administrator.
4. Go to "*`Site administration -> Notifications`*" , here on "*`Plugins check`*" page you will see the academi theme in listing.
5. Click the "Upgrade Moodle database now" button displayed on bottom of the page.
6. You will get success message once the theme installed successfully.
7. By clicking "*`Continue`*" button on success page , you will get options to change the academi theme settings.

Steps to set academi theme as default theme for your moodle system

1. Login as site administrator.
2. Go to "*`Site administration -> Appearance -> Themes -> Theme selector`*".
3. Click the "Change theme" button for device type as "Default"
4. It will list all the available themes for "Default device"
5. Then click "Use theme" button on "Academi theme"
6. Next click the "*`Continue`*" button ,thats it.
7. Cheers, you have done it !!!

## Usage & Settings

After installing the theme, it does not do anything to Moodle yet.

To configure the theme and its behaviour, please visit:
"*`Site administration -> Appearance -> Themes -> Academi`*".

There, you find multiple setting pages:

## General

In this tab there are the following settings:

**Logo**

Here, you can upload a complete logo for use as a decoration. This image will be utilized in the logo across all site pages, including the login page. Feel free to use a high-resolution version, as it will be scaled down as needed.

![logo](https://github.com/lmsace/academi/assets/98076459/5a2859ac-88e3-4e5f-a21e-66971015a3ea)

**Favicon**

Here, you can upload a custom image that will be displayed as the favicon for your Moodle website in the browser. If no custom favicon is uploaded, a standard Moodle favicon will be used.

![favicon](https://github.com/lmsace/academi/assets/98076459/fc4afb19-af61-4d08-bcb5-c41acffbb293)

**Primary Color**

With this setting, you can customize your site's primary color from the default color.

![primarycolor](https://github.com/lmsace/academi/assets/98076459/b58c06e9-4aad-435c-b62f-5696fa5cb224)

**Secondary Color**

With this setting, you can customize your site's secondary color from the default color.

![secndarycolor](https://github.com/lmsace/academi/assets/98076459/c97f640d-c4d7-4cb0-a851-52bb0aa5d4e8)

**Header Style**

With this feature, you can modify the header style on the whole site.

![headerstyle](https://github.com/lmsace/academi/assets/98076459/cdcfe7f4-e1cc-4b51-bb33-d19ac0dd282c)

   ***Theme Based***: If you select this theme-based option, the menus will be displayed in the bottom header.

![Academi](https://github.com/lmsace/academi/assets/98076459/b7f7d2bf-53f7-4788-8848-6a8dd86d511d)

   ***Moodle Based***: If you select this Moodle-based option, menus are displayed in the top header, and the bottom header will be hidden.

![Academi](https://github.com/lmsace/academi/assets/98076459/074dabfa-9604-458d-bb0b-8145e95e1c2e)

**Inner Page Content Size**

With this setting, you can change the content size option that will serve as the main inner content size across all Moodle inner pages on your site. This selection will not affect the content size of your home page.

   ***Container***: If you select the "Container" option, the inner page size will automatically be resized to the moodle container size (1140px).

   ***Moodle default***: If you select the "Moodle default" option, the inner page size will automatically be resized to the Moodle default container size (830px).

   ***Custom***: If you select the "custom" option, provide a pixel size in the following setting, and the main inner page size will be manually customized.

![innercontentsize](https://github.com/lmsace/academi/assets/98076459/b3a5ccf0-d3bb-41e5-b9c2-9c14ac792ce4)

**Page Content Custom Value**

With this setting, provide the custom pixel value to change the inner page main content size.

![customvalue](https://github.com/lmsace/academi/assets/98076459/74fb349c-09c5-43fc-a88f-36ea7cb2b74c)


**Content Font Size**

With this setting, you can choose the desired font size from the available options to customize the text size for your site's content.

   ***Default:*** When you select the "Default" option, the Moodle default font size will be applied to your entire site.

   ***Small:*** When you choose the "Small" option, a font size of "15px" will be applied to your entire site.

   ***Medium:*** When you opt for the "Medium" option, a font size of "17px" will be applied to your entire site.

   ***Large:*** When you select the "Large" option, a font size of "18px" will be applied to your entire site.

![content-font-size](https://github.com/lmsace/academi/assets/98076459/fe9f7018-7262-4088-b26b-0fefc4c95f9a)

**Available Courses Display Style**

With this setting, you can change the default design of available courses to our theme's design on the front page.

![available_course](https://github.com/lmsace/academi/assets/98076459/c50ba503-cefa-49f1-80c3-e9838d77208d)

   ***carousel***: If you select the "carousel" type, the design of available courses will be changed to a slider carousel style.

![Academi](https://github.com/lmsace/academi/assets/98076459/dda8f671-df82-4935-b828-7593ae776902)

   ***Moodle Based***: If you select the "Moodle based" type, the design of the available courses will be shown in the Moodle default style.

![available-course](https://github.com/lmsace/academi/assets/98076459/0389d2dc-3a6a-4143-b39b-c299c211f9b1)


**Combo List Display Style**

With this setting, you can change how the combo lists are displayed, either as collapsed or expanded type.

   ***collapsed***: If you select this setting, Combo lists are displayed at collapsed type.

   ***Expanded***: If you select this setting, Combo lists are displayed at expanded type.

![combolsit](https://github.com/lmsace/academi/assets/98076459/128867da-76aa-43a3-9be7-f4f7f7764ad9)

**Login Background Image**

Here, you can upload a background image for the login page.

![loginbg](https://github.com/lmsace/academi/assets/98076459/7021c0cb-8b3b-430c-995f-c8d7cbd611dd)

**Add Back To Top Button**

With this setting, you can control whether or not to enable a "Back to Top" button on your pages.

![backtotopbtn](https://github.com/lmsace/academi/assets/98076459/2b4c7917-2f57-4ab4-8ac7-857bed0507f8)

**Custom CSS**

With this setting, you can customize your CSS style to change the site's appearance.

![customcss](https://github.com/lmsace/academi/assets/98076459/c0b1697a-acb3-4dc2-bbea-2d215ae44e20)

### Theme Preset

**Theme Preset**

With this setting, you can utilize these options to modify the overall appearance of the theme, incorporating a range of diverse designs and styles. Moreover, we offer several preset files for this theme, including ***Academi***, ***Eguru***, ***Klass***, and ***Enlightlite***. We've introduced this new feature to elevate your Moodle experience, and we've also enhanced the design of additional front page blocks for each preset.

**Additional Theme Preset Files**

With this setting, you can upload your own preset files to alter the theme's appearance.

![preset](https://github.com/lmsace/academi/assets/98076459/8024a8c9-b92a-4813-aa55-276891d5ae85)


## HomePage Slider

![Homeslide](https://github.com/lmsace/academi/assets/98076459/59c097b4-2537-4c3e-9a23-4c88a4ed1d49)

### Front page Slide show

This feature generates a slideshow with a maximum of twelve slides, allowing you to highlight crucial aspects of your site. The slideshow is designed to be responsive, adjusting the image height based on the screen size. The recommended height is 418px. The width is set to 100%, resulting in a reduced actual height if the width exceeds the screen size. When the screen size is smaller, the height is dynamically decreased without requiring separate images.

**Slide Show Display**

With this setting, you have the option to choose whether you want to hide or display the slideshow.

![sliderstatus](https://github.com/lmsace/academi/assets/98076459/2b2763be-a9a8-42cc-b576-95b4e6e1af62)

**Auto Play**

With this setting, you can activate automatic scrolling of slides upon page load by using this option. When enabled, the homepage slider will automatically transition between slides without needing user input or interaction.

![autoplay](https://github.com/lmsace/academi/assets/98076459/074b866a-5da7-44d6-a1d1-c0b23eb79157)

**Pause Time**

With this setting, you can adjust the pause or wait time between each slide change in the slideshow using this option. The value is measured in milliseconds, where 1 second is equivalent to 1000 milliseconds.

![pausetime](https://github.com/lmsace/academi/assets/98076459/1ca79ebf-683e-4e4c-8c4c-c2e5d13aa41b)

**Overlay Opacity**

With this setting, you can manage the opacity level of the overlay in the slideshow content using this option. The default value for this option is 0.4, which translates to a 40% opacity. This allows the content behind the overlay to be partially visible.

![overlayopacity](https://github.com/lmsace/academi/assets/98076459/d6c07d3e-a279-43ad-af79-13d423c88505)

**Number of slides**

With this setting, begin by using the "Select the number of slides" option and then click the "Save Changes" button at the bottom of the settings page. Subsequently, the page will reload, and you will be provided with options and text fields for configuring the desired number of slides.

![numberofslide](https://github.com/lmsace/academi/assets/98076459/563fdbc9-5929-429c-88b2-0927998da4a3)

### Slide settings

**Status**

With this setting, you can regulate the visibility of a specific slide in the homepage slider. Select the "Disable" option for the slide you want to hide. Opting for "Disable" will prevent the slide from being displayed in the homepage slider, effectively concealing it.

![stauts](https://github.com/lmsace/academi/assets/98076459/6cbb14d6-292d-497b-bd05-f7d555bea827)

**Slide Image**

Here, you can upload your slide image to be displayed in the homepage slider.

![slideimage](https://github.com/lmsace/academi/assets/98076459/ab56d3cf-3112-42d6-9775-d6d3d3e47fd0)

**Slide Content**

With this setting, you can manage the visibility of slider content in the homepage slider. If the option is disabled, the slide content will not be displayed in the homepage slider.

![contentstatus](https://github.com/lmsace/academi/assets/98076459/feba0928-f564-4f1c-8aae-95ee73add232)

**Slide Caption**

Using these settings, you can input the text that will be displayed on the slide content in the homepage slider.

![caption](https://github.com/lmsace/academi/assets/98076459/309407ac-576f-4971-9cab-e59d21d364d0)

**Slide Description**

With this setting, you can provide a description for the slide content on the homepage slider.

![desc](https://github.com/lmsace/academi/assets/98076459/600901ed-3771-4a37-af4e-dba73f23bf1f)

**Button Text**

With this setting, you can set the text for the button on the slide using this option. If you don't want to include a button on your slide, you can leave this option blank.

![btntext](https://github.com/lmsace/academi/assets/98076459/1937e839-7054-4c2e-aa70-ebc5f63c3127)

**Button URL**

With this setting, you can establish the link for the button on the slide by using this option. Enter the URL or web address where you want the button to direct users when clicked.

![btnurl](https://github.com/lmsace/academi/assets/98076459/9635683a-038c-41af-8397-09a787d0bd6e)

**Button Target**

With this setting, when you select this option, clicking the button on the slide will open the linked content in a separate browser tab or window, keeping the original page unchanged.

![btntarget](https://github.com/lmsace/academi/assets/98076459/36d28d76-6583-4605-924e-ac816d81d8e4)

**Content Width**

With this setting, you can modify the content width of the slide by using this option. The content width will be calculated as a percentage of the main grid width. The default value for this option is 50%, which signifies that the content will occupy half of the available space in the slide.

![contentwidth](https://github.com/lmsace/academi/assets/98076459/436f0638-9128-4133-8c87-65366d771292)

**Content position**

With this setting, you can specify different positions for the slide content (title, description, and button) within the slide.

![contentposition](https://github.com/lmsace/academi/assets/98076459/4150dc73-059a-463b-a900-1efedf3b13ad)

## Promoted Course

Welcome to the Promoted Courses section, your gateway to showcasing tailored educational offerings on the forefront of your site's front page. With this dynamic feature, you have the power to spotlight your most relevant and captivating courses, right where visitors land.

Step into a realm of versatile designs specially crafted for the Promoted Courses block. Our team has meticulously developed a range of captivating layouts that seamlessly integrate with your website's aesthetics. Whether you're focused on professional development, academic pursuits, or skill enhancement, this block offers the ideal canvas to highlight the courses that matter most.

Imagine a fluid and immersive experience, where each course takes center stage in its dedicated space. Visitors are drawn into a journey of exploration, guided by a visual narrative that underscores the value of your educational offerings.

![promotedcourse](https://github.com/lmsace/academi/assets/98076459/5f634e15-611c-47ce-9e69-0cd5b6655e70)

**Activate Block**

This option enables you to manage the visibility of the promoted course and effectively control the content displayed on the front page.

![status](https://github.com/lmsace/academi/assets/98076459/020497ab-0857-4df2-bec0-1fbf0b422499)

**Title**

With this setting, you can input text for the title of the Promoted Course block on the front page.

![title](https://github.com/lmsace/academi/assets/98076459/eb468b0d-d4cf-4826-b532-952d22e0b957)

**Description**

Using this setting, you can provide a description for the title of the promoted course on the site's front page.

![description](https://github.com/lmsace/academi/assets/98076459/416638ee-7aea-4311-a31d-8fc74a92aa3b)

**Promoted Courses**

With this setting, you can provide the IDs of promoted courses separated by commas to display them in the Promoted Course block on the site's front page.

![pcourses](https://github.com/lmsace/academi/assets/98076459/289a1fac-8c44-4efb-8826-65b10e248a03)

## Site Features

**Activate Block**

This option allows you to control the visibility of the site features block and effectively manage the content displayed on the front page.

![sfeaturestatus](https://github.com/lmsace/academi/assets/98076459/6ba18979-6a7e-42a4-b061-90451a3a809b)

**Title**

With this setting, you can enter text for the title of the Site Features block on the front page.

![title](https://github.com/lmsace/academi/assets/98076459/24f5a0af-adf7-45ad-9dfe-7c573920d559)

**Description**

By utilizing this setting, you can offer a description for the title of the Site Feature block on the site's front page.

![description](https://github.com/lmsace/academi/assets/98076459/3f4bb01a-4306-4565-afd3-be27f450b114)

**Site Feature Icon / Image**

Using this setting, you can choose to display the site feature as either an icon or an image type on the front page.

![icon_image](https://github.com/lmsace/academi/assets/98076459/f4d85791-0d52-48f9-8a01-b9ccb68ba75a)

***Icon***: By selecting the "Icon" option in the dropdown menu, the site feature will be displayed in an icon-based design on the front page.

![site-feature](https://github.com/lmsace/academi/assets/98076459/4189de64-4615-4782-b8e9-8d474c5f9ca7)

***Image***: When you choose the "Image" option from the dropdown menu, the site feature will be presented with an image-based design on the front page.

![Academi](https://github.com/lmsace/academi/assets/98076459/f0c0960d-9179-45b1-994e-64c6acaf55f1)

**Number of Site Features**

To utilize this setting, start by utilizing the "Select the number of site features" option, then proceed to click the "Save Changes" button located at the bottom of the settings page. Following this action, the page will refresh, and you will gain access to options and text fields for configuring the desired number of site features.

![numbersitefeature](https://github.com/lmsace/academi/assets/98076459/0cacd679-635e-486b-8241-dd181eadd4ac)

### Site features settings

**Activate block**

This option enables you to control the visibility of a specific site feature within the site features block.

![status](https://github.com/lmsace/academi/assets/98076459/a750c095-065d-48c5-bf0f-0969356fa6f8)

**Title**

Using this setting, you can input the text for the title of a specific site feature within the site features block on the front page.

![title](https://github.com/lmsace/academi/assets/98076459/3d278a89-1b65-49f9-b1f9-880494302763)

**Content**

With this setting, you can enter the content for a specific site feature within the site features block.

![content](https://github.com/lmsace/academi/assets/98076459/457ee3a5-57f0-4a58-b652-dc71c22f4708)

**Icon**

Using this setting, you can input the name of the icon you want to use for this particular site feature. Only enter what comes after "fa-".

![icon](https://github.com/lmsace/academi/assets/98076459/ee2c1e98-6214-4eb9-8579-35b7f35ad401)

**Image**

With this setting, you can upload a custom image for the "Featured element." We recommend using images with dimensions of 75 x 75 pixels.

![image](https://github.com/lmsace/academi/assets/98076459/028f91fe-614b-47e1-928b-61d602fd1b35)

## Marketing Spot

In the "Academi" theme, a marketing spot serves as a prominent area where you can effectively highlight important content, products, or promotions on your site's front page. This feature allows you to grab visitors' attention and convey key messages.

![marketing-spot](https://github.com/lmsace/academi/assets/98076459/5e6aeb4d-fbb8-4136-847b-90b3e88c6549)

**Activate Block**

This option enables you to manage the visibility of the Marketing spot block and effectively control the content displayed on the front page.

![status](https://github.com/lmsace/academi/assets/98076459/b60d1d2f-0091-46f2-ac93-55d6e2315c70)

**Title**

Using this setting, you can input text for the title of the Marketing Spot block on the front page.
Enter a catchy and concise title for the marketing spot. This title will draw the visitors' attention and provide context for the content.

![title](https://github.com/lmsace/academi/assets/98076459/09b7f054-ae56-4ab8-9b38-b2cb68c77359)

**Description**

By utilizing this configuration, you can provide a description for the title of the Marketing Spot on the front page of the site.

![description](https://github.com/lmsace/academi/assets/98076459/86c1c8ba-a460-46cc-b904-1ee40ff2015d)

**Content**

Through this setting, you can input the content to be displayed in the Marketing Spot on the front page.
Add a brief content description that further explains the purpose of the marketing spot or provides more information about what's being showcased.

![content](https://github.com/lmsace/academi/assets/98076459/95ef5f89-89ce-469c-b579-38435edf46c9)

**Media**

Use the provided image upload functionality to select and upload an image file. Ensure that the image format is one of the supported types, such as .gif, .jpe, .jpeg, .jpg, .png, .svg, or .svgz. This image will visually represent the content you're promoting.

![media](https://github.com/lmsace/academi/assets/98076459/fede2144-1e10-4a0c-890e-199dd5dfda10)

## Jumbotron

The Jumbotron block in the "Academi" theme offers a chance to create a powerful initial impact and communicate the core of your site or organization. Its central placement makes it an excellent space for delivering concise, compelling, and visually appealing information.

![Academi](https://github.com/lmsace/academi/assets/98076459/2bb3e96a-9e10-4b6a-969c-67ccb9d0dcc5)

**Activate block**

This option allows you to control the visibility of the Jumbotron block and effectively manage the content displayed on the front page.

![status](https://github.com/lmsace/academi/assets/98076459/66a742ac-a463-4607-8dea-741f4bbdbb15)

**Title**

Utilizing this setting, you can enter text for the title of the Jumbotron block on the front page. Craft a captivating and succinct title for the Jumbotron. This title will capture visitors' attention and offer context for the content.

![title](https://github.com/lmsace/academi/assets/98076459/34c2fc88-9b04-4fd9-b95f-ce8da73569fa)

**Description**

By utilizing this setting, you have the ability to input the content that will be showcased in the Jumbotron on the front page. Include a concise content description that provides additional insight into the purpose of the Jumbotron or offers more details about the content being featured.

![description](https://github.com/lmsace/academi/assets/98076459/40c9b1a5-bdf6-475b-b40f-b5dda5ac4730)

**Button Text**

Using this setting, you can specify the text for the button on the Jumbotron using this option. If you choose not to include a button on your slide, you can leave this field blank.

![btntext](https://github.com/lmsace/academi/assets/98076459/d5e424b8-7feb-4176-abe6-47ced48059a1)

**Button Link**

Through this setting, you can define the link for the button on the Jumbotron using this option. Input the URL or web address where you want the button to redirect users when it's clicked.

![btnlink](https://github.com/lmsace/academi/assets/98076459/83cf5594-b8d9-469a-b0f4-0cb3b8bf6283)

**Button target**

Through this setting, upon selecting this option, clicking the button on the Jumbotron will result in opening the linked content in a separate browser tab or window. This action preserves the original page without any changes.

![btntarget](https://github.com/lmsace/academi/assets/98076459/2e36b6a3-f579-451e-871b-da6919318e38)

## Footer

Discover our enhanced and highly responsive theme footer block, meticulously designed to elevate both functionality and visual appeal. With an additional footer block that seamlessly integrates, your website's footer is about to undergo a captivating transformation.

Our meticulously crafted theme footer block is engineered to provide an unparalleled user experience. Its enhanced responsiveness ensures optimal display across various devices, from desktops to smartphones, making your website accessible to a wider audience.

Moreover, the new footer block introduces an enticing glow, adding a touch of sophistication to the overall design. This subtle radiance draws attention to your footer section, creating an attractive focal point that engages visitors and encourages them to explore further.

Experience the seamless blend of efficiency and aesthetics as our revamped footer block becomes an integral part of your website's identity. Elevate your online presence with a footer that not only delivers essential information but also enhances the visual appeal of your entire website. Welcome to the future of footers – dynamic, engaging, and designed to captivate.

![footer](https://github.com/lmsace/academi/assets/98076459/5375d110-0c34-4bca-94d6-f6c519c7af79)

### Genral Footer Block

**Footer background Image**

In this section, you have the option to upload a background image for the footer block. If you choose to leave this section empty, the default background color will be displayed instead. This allows you to customize the visual appearance of the footer block according to your preferences.

![footerbg](https://github.com/lmsace/academi/assets/98076459/ca5b26e9-f643-4d93-aef5-b2e621eae31b)

**Footer Overlay Opacity**

Using this setting, you can regulate the opacity level of the overlay within the footer block. This option is effective when a footer background image is present. The default value for this setting is 0.4, resulting in a 40% opacity for the overlay. This transparency enables the content behind it to be partially visible, creating a layered visual effect.

![footeropacity](https://github.com/lmsace/academi/assets/98076459/317368e3-68ae-4280-b8be-a9134d515793)

**Copyright**

Using this setting, you can input the copyright information for your site. This copyright notice will be displayed at the bottom of the footer block.

![copyright](https://github.com/lmsace/academi/assets/98076459/91e2732a-db60-42f5-b348-61bb6b9075ac)

### Footer Block 1

**Activate block**

Through this setting, if you want to deactivate this block in the footer section, simply uncheck the "Activate this block" checkbox.

![status](https://github.com/lmsace/academi/assets/98076459/492297be-2fb6-46d2-afe4-4f7ff196d414)

**Title**

Using this setting, you can input the text for the title of Footer Section 1 in the footer area.

![title](https://github.com/lmsace/academi/assets/98076459/a7460896-ba04-44fd-a05d-e4ed1e2a1612)

**Footerlogo Enable**

By utilizing this setting, you can manage the visibility of the Footer logo, choosing to either display or hide it within the footer.

![footerlogostatus](https://github.com/lmsace/academi/assets/98076459/7453182d-4c8b-44da-8508-d42da0e40e74)

**Footer logo**

You can upload your custom footer logo here if you wish to add it to the footer. The recommended dimensions for the image are 80 pixels in height and a reasonable width, with a minimum width of 205 pixels to ensure it fits appropriately within the footer.

![footerlogo](https://github.com/lmsace/academi/assets/98076459/6558bda4-edd5-4dea-8393-0f62055b9394)

**Footnote**

Through this setting, you have the ability to input the content that you intend to display within the footer block. This setting is useful for showcasing your site's information or presenting other activities within the footer block.

![footernote](https://github.com/lmsace/academi/assets/98076459/25605c21-eee8-40fa-b34a-2c4f3823583c)

### Footer Block 2

**Activate Block**

Through this setting, if you want to deactivate this block in the footer section, simply uncheck the "Activate this block" checkbox.

![status](https://github.com/lmsace/academi/assets/98076459/e68faccf-0684-433c-b114-ca90f8afd0e4)

**Title**

With this setting, you can input the text that will serve as the title for Footer Section 2 within the footer area.

![title](https://github.com/lmsace/academi/assets/98076459/f674c565-7045-403e-b105-01f4019f37d1)

**Info Links**

By utilizing this setting, you have the capability to set up custom Info Links that will be displayed by the theme. Each line can include menu text, an optional link URL, an optional tooltip title, and an optional language code or a comma-separated list of codes. These language codes allow you to display the line to users of the specified language(s) only. The different elements within each line should be separated by pipe characters (|).

![infolinks](https://github.com/lmsace/academi/assets/98076459/0ac36d47-17d4-470d-a96b-9d836e973429)

### Footer Block 3

**Activate Block**

Through this setting, if you want to deactivate this block in the footer section, simply uncheck the "Activate this block" checkbox.

![status](https://github.com/lmsace/academi/assets/98076459/dd96308f-67c5-4930-a660-51d8071bb643)

**Title**

With this setting, you can input the text that will serve as the title for Footer Section 3 within the footer area.

![title](https://github.com/lmsace/academi/assets/98076459/77bfdd2d-b637-4c7a-88fc-acc5e3030e08)

**Address**

Through this setting, you can input your address details, and these details will be displayed in the footer block. This is a way to share your address information with visitors through the footer section of your site.

![address](https://github.com/lmsace/academi/assets/98076459/945a7e6b-bd07-43b3-b8dd-b1a2ce94433a)

**Email**

Using this setting, you can input your email address to be displayed in the footer block. This feature makes it easier for visitors to contact you by providing a visible email contact in the footer section.

![email](https://github.com/lmsace/academi/assets/98076459/d82071e2-3ab4-4be4-af87-c957be556a57)

**Phone No**

By utilizing this setting, you can input your phone number to be displayed in the footer block. This feature is helpful for visitors who may need to contact you via phone, as it provides a visible phone number within the footer section for easy access.

![phonenumber](https://github.com/lmsace/academi/assets/98076459/b93e6b6a-7996-4514-86af-a5a8920df4e3)

### Footer Block 4

**Activate Block**

Through this setting, if you want to deactivate this block in the footer section, simply uncheck the "Activate this block" checkbox.

![status](https://github.com/lmsace/academi/assets/98076459/ce48773d-ac3c-470b-bf4b-f4d2b6ea95a5)

**Title**

With this setting, you can input the text that will serve as the title for Footer Section 4 within the footer area.

![title](https://github.com/lmsace/academi/assets/98076459/8454a33d-4750-4dcb-a3a8-86c078f4efb4)

**Number of Social Media**

Using this setting, first, you need to choose the "Select the number of social media" option. Afterward, click the "Save Changes" button located at the bottom of the settings page. Following this action, the page will refresh, and you'll gain access to options and text fields enabling you to configure the specific number of social media profiles to be displayed within the footer block.

![numberofsocialmedia](https://github.com/lmsace/academi/assets/98076459/de70a410-f6f5-47eb-9c21-35178fadd936)

### Social Media

**Activate your social media**

Using this setting, you have the capability to determine which of your individual social media profiles will be showcased in your footer block. If you choose to uncheck the setting for a particular social media platform, that specific platform will not be displayed in the footer block. This allows you to selectively control which social media icons or links are visible in the footer.

![socialmedia_status](https://github.com/lmsace/academi/assets/98076459/6772d9ea-3776-4e06-baf7-7258f46c9085)

**Icon**

Using this setting, you can input the name of the social media icon you want to use, specifically the part that comes after "fa-". This input will correspond to the appropriate icon in the chosen icon set.

![icon](https://github.com/lmsace/academi/assets/98076459/80973167-7923-4bfb-ad84-db94216f124a)

**URL**

Through this setting, you can provide a URL link that the social media icon will redirect to when clicked by users. This link will determine where visitors are taken when they click on the respective social media icon.

![url](https://github.com/lmsace/academi/assets/98076459/5487d0df-a5c2-4ab9-aa1c-200de428449b)

**Icon Color**

Using this setting, you have the ability to alter the color of your social media icons. If you choose not to change the color of the social media icons, you can leave this field empty, and the icons will be displayed in their default color.

![iconcolor](https://github.com/lmsace/academi/assets/98076459/6a65dcd1-de7d-4667-ab78-99a9be867710)
